<?php

function get_sql($table_prefix)
{
    $sql = "

        CREATE TABLE IF NOT EXISTS `".$table_prefix."users` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `name` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `email` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `is_admin` int(11) DEFAULT '0',
          `status` int(11) DEFAULT '0',
          `password` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `fb_user_id` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `fb_token` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `fb_user_name` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `timezone` varchar(250) COLLATE utf8_bin DEFAULT 'Europe/London',
          `created_at` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `last_login` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `sent_mail` int(11) DEFAULT '0',
          `app_id` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `app_secret` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `fb_logged_in` int(11) DEFAULT '0',
          `allow_fb_app` int(11) DEFAULT '1',
          `fb_pages_limit` int(11) DEFAULT '1',
          `token` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

        CREATE TABLE IF NOT EXISTS `".$table_prefix."schedules` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `user_id` int(11) DEFAULT NULL,
          `fb_user_id` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `fb_user_name` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `fb_token` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `source_type` int(11) DEFAULT '1',
          `pages` text COLLATE utf8_bin,
          `posts` text COLLATE utf8_bin,
          `condition_type` int(11) DEFAULT NULL,
          `comment` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `keyword` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `start_timestamp` bigint(20) DEFAULT NULL,
          `end_timestamp` bigint(20) DEFAULT NULL,
          `created_at` bigint(20) DEFAULT NULL,
          `changed_at` bigint(20) DEFAULT NULL,
          `is_repeat` int(11) DEFAULT '0',
          `repeat_frequency` int(11) DEFAULT '0',
          `repeat_weekdays` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `repeat_interval` int(11) DEFAULT '0',
          `auto_delete` int(11) DEFAULT '0',
          `delete_type` int(11) DEFAULT '0',
          `delete_interval` int(11) DEFAULT '0',
          `delete_timestamp` bigint(20) DEFAULT '0',
          `next_set_timestamp` bigint(20) DEFAULT '0',
          `add_condition` int(11) DEFAULT '0',
          `add_keyword` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `status` int(11) DEFAULT '0',
          PRIMARY KEY (`id`),
          KEY `".$table_prefix."user_id` (`user_id`),
          KEY `".$table_prefix."fb_user_id` (`fb_user_id`),
          CONSTRAINT `".$table_prefix."user_id` FOREIGN KEY (`user_id`) REFERENCES `".$table_prefix."users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

        CREATE TABLE IF NOT EXISTS `".$table_prefix."schedules_queue` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `schedule_id` int(11) DEFAULT NULL,
          `status` int(11) DEFAULT '1',
          `user_id` int(11) DEFAULT NULL,
          `set_datetime` bigint(20) DEFAULT '0',
          `del_datetime` bigint(20) DEFAULT '0',
          `page_id` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `post_id` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `can_comment` int(11) DEFAULT '1',
          `error` text COLLATE utf8_bin,
          PRIMARY KEY (`id`),
          KEY `".$table_prefix."schedule_id` (`schedule_id`),
          CONSTRAINT `".$table_prefix."schedule_id` FOREIGN KEY (`schedule_id`) REFERENCES `".$table_prefix."schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

        CREATE TABLE IF NOT EXISTS `".$table_prefix."completed` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `schedule_id` int(11) DEFAULT NULL,
          `queue_id` int(11) DEFAULT NULL,
          `comment` text COLLATE utf8_bin,
          `fb_comment_id` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `parrent_comment_id` varchar(50) COLLATE utf8_bin DEFAULT '0',
          PRIMARY KEY (`id`),
          KEY `".$table_prefix."schedule_id` (`schedule_id`),
          KEY `".$table_prefix."queue_id` (`queue_id`),
          CONSTRAINT `".$table_prefix."queue_id` FOREIGN KEY (`queue_id`) REFERENCES `".$table_prefix."schedules_queue` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

        CREATE TABLE IF NOT EXISTS `".$table_prefix."user_groups` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `user_id` int(11) DEFAULT NULL,
          `groups` longtext COLLATE utf8_bin,
          PRIMARY KEY (`id`),
          KEY `".$table_prefix."user_id` (`user_id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

        CREATE TABLE IF NOT EXISTS `".$table_prefix."global_config` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `param` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          `value` varchar(250) COLLATE utf8_bin DEFAULT NULL,
          PRIMARY KEY (`id`),
          UNIQUE KEY `".$table_prefix."unique_param` (`param`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

        CREATE TABLE IF NOT EXISTS `".$table_prefix."license` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `key` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          `value` varchar(50) COLLATE utf8_bin DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

    ";

    return $sql;
}